// GPA Test image 0 by mjh
// Creates and image with a central displaced section.

number ncols = 1024
number ocol = ncols/2
number nrows = ncols
number orow = nrows/2

image pic := realimage("GPA Test 0 2D", 4, ncols, nrows)

number a_p = 30 // fringe spacing in pixels in x-direction
number b_p = 15

number ux = -1   // fringe displacement in pixels
number uy = 2

number gx1 = 1/a_p     
number gy1 = 0	// reciprocal lattice vector gx,gy in pixels-1

number gx2 = 0
number gy2 = 1/b_p

pic = tert(modulus(icol-ocol)<ncols/8, cos(2*Pi()*gx1*(icol-ocol))+cos(2*Pi()*gy2*(orow-irow)), cos(2*Pi()*gx1*(icol-ocol+ux))+cos(2*Pi()*gy2*(orow-irow+uy)))

pic = pic + GaussianRandom()*0.1
pic = pic**2

number pixel_nm = 0.3/15   // nm par pixel

SetScale(pic, pixel_nm, pixel_nm)

ImageSetDimensionUnitString(pic, 0, "nm")
ImageSetDimensionUnitString(pic, 1, "nm")

showimage(pic)